--------------------------------------------------------------------
-- Dashboard / Übersichtsseite
--------------------------------------------------------------------

-- Funktion die den HTML-Code für die Dashboard-Seite generiert
CREATE OR REPLACE FUNCTION api.dashboard_page()
  RETURNS "text/html"
  SECURITY DEFINER
  AS $BODY$
    SELECT concat_ws( E'\n',
        '<!DOCTYPE html>', '<html lang="de">',
        api.html_head_get('Übersicht'),
    $html$
<body class="bg-gray-50 text-gray-800 min-h-screen">
  <nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
    <h1 class="text-xl font-semibold">Prodat ERP</h1>
    <button onclick="logout()" class="px-4 py-2 border rounded hover:bg-gray-100 text-sm">Abmelden</button>
  </nav>

  <main class="max-w-5xl mx-auto px-4 py-8">
    <div id="cards" class="grid md:grid-cols-2 gap-6"></div>
  </main>

  <script>

    function logout() {
      document.cookie = "jwt=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT";
      window.location.href = 'login_page';
    }

    function navigateTo(url) {
      const currentCard = event.currentTarget;
      currentCard.style.transform = 'scale(0.95)';
      setTimeout(() => {
        window.location.href = url;
      }, 200);
    }

    document.addEventListener('DOMContentLoaded', () => {

      const modules = [
        {
          url: 'inventur',
          title: 'Inventur',
          description: 'Verwaltung und Durchführung von Inventuren'
        }
        ,
        {
          url: 'artinventarausgabe_page',
          title: 'Inventarausgabe',
          description: 'Verwaltung und Dokumentation der Werkzeugausgabe'
        }
        //,
        //{
        //  url: 'fertigungsauftragsbearbeitung_page',
        //  title: 'Fertigungsauftragsbearbeitung',
        //  description: 'Verwaltung und Bearbeitung von Fertigungsaufträgen'
        //}
      ];

      import('./file?path=component_cards.js').then(({ renderCards }) => {
        renderCards({
          data: modules,
          containerId: 'cards'
        });
      });
    });
  </script>
</body>
</html>
    $html$);
  $BODY$ LANGUAGE sql;
  GRANT EXECUTE ON FUNCTION api.dashboard_page() TO "sys_postgrest_anon";


-----------------------------------
-- Fertigungsauftragsbearbeitung
-----------------------------------

/*CREATE OR REPLACE FUNCTION api.fertigungsauftragsbearbeitung_page()
  RETURNS "text/html"
  AS $BODY$
  SELECT concat_ws( E'\n',
  '<!DOCTYPE html>', '<html lang="de">',
  api.html_head_get(),
  $html$
  <body class="bg-gray-50 text-gray-800">

    <!-- Navigation -->
    <nav class="bg-white shadow px-6 py-4 flex justify-between items-center">
      <h1 class="text-xl font-semibold">Prodat ERP</h1>
      <button id="logoutBtn" class="       px-4 py-2 border                 rounded hover:bg-gray-100 text-sm">Abmelden</button>
      <button id="loginBtn"  class="hidden px-4 py-2 border border-gray-400 rounded hover:bg-gray-100        ">Login</button>
    </nav>

    <main class="max-w-none mx-auto px-4 py-6">
      <!-- KPI Karten -->
      <div id="kpi-cards" class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8"></div>

      <!-- Hauptbereich -->
      <div id="fa-container"></div>
    </main>

    <script type="module">
      import { renderTable } from './file?path=component_table.js';
      import { renderCards } from './file?path=component_cards.js';

      // KPI Karten rendern
      renderCards({
        containerId: 'kpi-cards',
        data: [
          {
            title: 'Offene Aufträge',
            description: '25 Aufträge in Bearbeitung',
            url: ''
          },
          {
            title: 'Auslastung',
            description: '85% Kapazitätsauslastung',
            url: ''
          },
          {
            title: 'Termingerecht',
            description: '92% der Aufträge im Zeitplan',
            url: ''
          }
        ]
      });

      // Tabelle rendern
      renderTable({
        endpoint: './execute_standard_sql_to_jsonb_set',
        containerId: 'fa-container',
        title: 'Fertigungsaufträge',
        columns: [
          { field: 'ag_nr', header: 'Auftrag' },
          { field: 'ab_ix', header: 'ABK' },
          { field: 'a2_n', header: 'Arbeitsgang' },
          { field: 'ak_bez', header: 'Bezeichnung' },
          { field: 'st_n', header: 'Artikelnummer' },
          { field: 'a2_subject', header: 'Arbeitsschritt' },
          { field: 'ks_abt', header: 'Kostenstelle' },
          { field: 'a2_at', header: 'Starttermin', type: 'date' },
          { field: 'a2_et', header: 'Endtermin', type: 'date' },
          { field: 'a2_ta', header: 'Zeit (h)' },
          { field: 'ab_st_uf1', header: 'Menge' },
          { field: 'abk_proz_fertig', header: 'erledigt', type: 'progress' },
          { field: 'ab2.bearbtg.ncprog', header: 'NC-Programm', type: 'boolean' }
        ],
        sqlParameter: 'Sondermodul.Fertigungsauftragsbearbeitung',
        refreshInterval: 300000 // Optional: Alle 5 Minuten aktualisieren
      });

      // Login Button Handler
      document.getElementById("loginBtn").addEventListener("click", function () {
        window.location.href = './login_page';
      });

      // Logout Button Handler
      document.getElementById("logoutBtn").addEventListener("click", function () {
        document.cookie = "jwt=; path=/; expires=Thu, 01 Jan 1970 00:00:00 GMT";
        window.location.href = './login_page';
      });
    </script>
  </body>
  </html>$html$ );
$BODY$ LANGUAGE sql;
*/